/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xiocommo.h
 *       Block Reading/writing (2925 only)
 * -----------------------------------------------------------------*/

#ifndef XIOCOMMON_H_INCLUDED
#define XIOCOMMON_H_INCLUDED


#define MAX_BLOCK_LEN_2925  127

/* USB_BLOCKSIZE_MAX must be less or equal MAX_XFER_SIZE in ezusbsys.c
   It should be a multiple of the USB paketsize (64/512 bytes in USB1/2) and  
   a multiple of the tracememory width (24 resp. 16 bytes per line in mode2/1).
   If you change these do not forget to adapt the corresponding FW/driver files too.
*/
#define USB_BLOCKSIZE_MAX  0x1fe00 /* 2^9 * 3 * 5 * 17   */
#define FHIF_BLOCKSIZE_MAX 0x1eff0 /* 2^4 * 3 * 5 * 23^2 */

#ifdef __cplusplus
extern "C" {
#endif
  

  bx_errtype EXPORT BestXBasicBlockWrite(
  bx_handletype handle,
  bx_int32      register_number,
  bx_int8ptr    bt_ptr,
  size_t        num_of_bytes
                     );


  bx_errtype EXPORT BestXBasicBlockRead(
  bx_handletype  handle,
  bx_int32       register_number,
  bx_int8ptr     bt_ptr,
  bx_int32       num_of_bytes
                    );


  bx_errtype BestXBasicCommand8Bit(
  bx_handletype handle,
  bx_int32 addr,       /* 8-bit address to be sent to BestX */
  bx_int8 cmd,         /* CMD_READ or CMD_WRITE */
  bx_int8ptr  byteptr,   /* addr of data to be read/written */
  bx_int8 regwidth,    /* using register width nn */
  size_t NumBytes);  /* length of data at byteptr */


/* BestXBasicCommand

   The new 16-bit register file has a different philosophy of how the
   card is addressed. You should imagine onboard calls like a procedure
   that gets called through this interface.

   arguments:
   handle    - identifies port and hardware
   cmdcode    - 16-bit code identifying the called function
   inptr    - pointer to arguments for the call
   insize    - size of arguments
   outptr    - result of the called function
   outsize    - size of the result in bytes

   If a the in or out buffer is set to zero then the according size parameter
   is ignored and implicitly set to zero. In this case also outsize may be
   set to zero

   return values:
   BX_E_OK
   BX_E_FUNC    - the onboard function failed, useaccording CAPI calls to
             get detailed error message
*/

  bx_errtype EXPORT BestXBasicCommand (bx_handletype handle,
  bx_int16      cmdcode,
  bx_int8ptr    inptr,
  bx_int16      insize,
  bx_int8ptr    outptr,
  bx_int16     *outsize);


/* BestXBasicCommandVariable

  This functions calls BestXBasicCommand and handles buffers with variable
  length. A Transfer of this type MUST be defined in reg*.h as VARIABLE 
  or LENGTHNEGOTIABLE */
  bx_errtype EXPORT BestXBasicCommandVariable (bx_handletype handle,
  bx_int16   cmdcode,
  bx_int8ptr inptr,
  bx_int16   insize,
  bx_int8ptr outptr,
  bx_int16   *outsize);


/* --------------------------------------------------------------------------
 * Block Reading/writing (2926 only)
 * Note that a limited subset of bx_resourcetype is valid for block I/O. 
 * -------------------------------------------------------------------------- */

bx_errtype BestXBasicBlockCommand(
    bx_handletype handle,
    bx_int32 address,
    bx_int32 numbytes,
    bx_int8  regwidth,
    bx_int8  writecmd, /* CMD_READ or CMD_WRITE */
    bx_bool  autoinc,  /* TRUE (HW increments) FALSE (SW increments)*/
    bx_int8ptr  pData  /* addr of caller's buffer to read/write */
  );

  bx_errtype BestXWaitForClose (
  bx_handletype handle,
  bx_int32 timeout
  );


#ifdef __cplusplus
}
#endif


#endif





